# Hoisting

자바스크립트 엔진은 연산을 위해 **표현식(expression)** 을 **해석(parsing)** 하여 연산자와 피연산자를 파악한다.  
**메모리**에 피연산자 등의 데이터를 기억하고 **CPU**를 사용해 연산한다.

**메모리(memory)**  
메모리는 데이터를 저장할 수 있는 메모리 셀(memory cell)의 집합체이다.

- 메모리 셀 하나의 크기는 **1바이트(8비트)** 이며, 1바이트 단위로 데이터를 저장(write)하거나 읽어(read)들인다.
- 모든 데이터는 **2진수**로 저장된다.
- **메모리주소(memory address)** 는 각 셀이 고유하게 가지고 있는 메모리 공간의 위치 값이다. 메모리 크기 범위의 정수값이다.  
  _ex) 4GB 메모리는 `0x00000000` ~ `0xFFFFFFFF`의 주소를 갖는다._

<img src="https://user-images.githubusercontent.com/66757141/212366880-e8c326bf-213a-4c69-a681-850c2dd33ff6.png" alt="memory_cell" width="360px" /><br/>
_[image reference](https://velog.io/@chillihc/JavaScript-모던-자바스크립트-Deep-Dive로-배우는-JS-3-자바스크립트-개발-환경과-실행-방법-ytv11p6z) ( ex `10+20` 연산시 피연산자의 메모리 할당 )_

**메모리 주소로 데이터에 접근 불가**
다음과 같은 이유로 메모리 주소로 데이터에 직접 접근할 수 없다.

1. 자바스크립트는 개발자의 직접적 메모리 제어를 허용하지 않는다.  
   직접적인 메모리 제어시 의도치 않은 수정으로 치명적인 문제가 발생할 수 있기 때문이다.
2. 값이 저장될 메모리의 주소는 코드가 실행될 때 메모리의 상황에 따라 임의로 결정되기 때문에 사전에 메모리 주소를 알 수 없다.

따라서 프로그래밍 언어는 값을 메모리에 저장하고, 저장된 값을 읽어 들여 재사용하기 위해 **변수** 라는 메커니즘을 제공한다.

<br/>

## 4.1 변수

**변수(Variable)** 는 하나의 값을 저장하기 위해 확보한 메모리 공간 자체 또는 그 메모리 공간을 식별하기 위해 붙인 이름을 말한다.  
프로그래밍 언어에서 변수는 **컴파일러** 또는 **인터프리터** 에 의해 값이 저장된 메모리 공간의 주소로 치환되어 실행된다. 직접 메모리주소를 사용하지 않아 안전하다.

<img src="https://user-images.githubusercontent.com/66757141/212366913-43851008-c858-4776-8925-30ded9877fb2.png" alt="memory_assign" width="500px" /><br/>
_[image reference](https://velog.io/@chillihc/JavaScript-모던-자바스크립트-Deep-Dive로-배우는-JS-3-자바스크립트-개발-환경과-실행-방법-ytv11p6z)_

**용어 정리**

- `변수 이름` : 메모리 공간에 저장된 값을 식별할 수 있는 고유한 이름, 변수명.
- `변수 값` : 변수에 저장된 값
- `할당(assignment)` : 변수에 값을 저장하는 것
- `참조(reference)` : 변수의 값을 읽어오는 것

<br/>

## 4.2 식별자

**식별자(identifier)** 는 어떤 값을 구별해서 식별할 수 있는 고유한 이름을 말한다. 변수, 함수, 클래스 등의 이름은 모두 식별자이다.

- 식별자는 값이 아니라, 값이 저장된 메모리 주소를 기억한다.
- 식별자는 선언(declaration)에 의해 자바스크립트 엔진에 존재를 알린다.

<br/>

## 4.3 변수 선언

**변수 선언(variable declaration)** 이란 변수를 생성하는 것을 말한다.

- `var`, `let`, `const` 키워드\*를 사용한다.  
  _\* 키워드(keyword)는 자바스크립트 엔진이 수행할 동작을 규정한 일종의 명령어이다._
- 구체적으로 변수 선언은 메모리 공간을 **확보(allocate)** 하고, 메모리 공간의 주소를 변수 **이름에 연결(name binding)** 하는 것이다.
- 자바스크립트의 변수 선언은 다음과 같은 단계를 거친다.
  1. **선언 단계** : 변수 이름을 등록\*해서 자바스크립트 엔진에 변수의 존재를 알린다.
  2. **초기화 단계** : 값을 저장하기 위한 메모리 공간을 확보(allocate)하고 암묵적으로 `undefined` 를 할당해 초기화한다.

선언하지 않은 식별자에 접근하면 `ReferenceError(참조 에러)` 가 발생한다. 참조 에러는 자바스크립트 엔진이 참조하려는 식별자를 찾을 수 없을때 발생한다.

<br/>

## 4.4 호이스팅

**호이스팅(variable hoisting)** 은 선언문이 코드의 선두로 끌어 올려진 것처럼 동작하는 자바스크립트 고유의 특징이다.

1. 자바스크립트 엔진은 코드를 순차적으로 실행하기 전 소스코드의 **평가과정** 을 거치며 실행 준비를 한다.
2. 평가과정에서 변수 선언을 포함한 모든 선언문을 소스코드에서 찾아내 먼저 실행한다.
3. 평가 과정이 끝나면 모든 선언문을 제외하고 소스코드를 순차적으로 실행한다.

```js
console.log(score); // undefined
var score;
```

따라서 위와 같이 선언문 전 참조문을 사용하더라도 선언문이 호이스팅되어 먼저 실행되므로 `참조에러(ReferenceError)`가 발생하지 않고 초기값 `undefined`가 출력된다.

<br/>

## 4.5 값의 할당

변수에 값을 저장하는 **할당(assignment)** 은 할당 연산자 `=` 를 사용한다.  
할당 연산자 `=` 는 우변의 값을 좌변의 변수에 할당한다.

```js
var score; //변수 선언
score = 80; // 변수 할당
```

```js
var score = 80; //변수 선언과 값의 할당
```

변수 선언과 할당은 위와 같이 하나의 문(statement)으로 단축 표현할 수도 있다.  
하지만 단축하여 사용해도 `선언부`는 런타임 이전에 호이스팅되고, `변수 할당`은 런타임에 **분리되어 실행** 된다.

<br/>

## 4.6 값의 재할당

**재할당** 이란 이미 값이 할당되어있는 변수에 새로운 값을 다시 할당하는 것을 말한다.

- 기존 메모리 공간의 값을 지우고 새 값을 저장하는 것이 아니라, **새로운 메모리 공간을 확보하여 저장** 한다.
- var 키워드로 선언한 변수는 선언과 동시에 `undefined`로 초기화되기 때문에 엄밀히 말하면 처음으로 값을 할당하는 것도 재할당이다.
  - _ES6에서 도입한 const 키워드를 사용하면 해당 변수는 재할당이 금지되어 상수를 표현할 수 있다._
- 식별자와 연결이 끊어진 기존 값은 가비지 콜렉터에 의해 자동으로 해지\*되며, 해지 시점은 예측할 수 없다.
  - _가비지 콜렉터(garbage collector)가 자동으로 메모리 해지를 수행하는 언어를 **매니지드 언어(managed language)** , 개발자가 명시적으로 해지하는 언어를 **언매니지드 언어(unmanaged language)** 라고 한다._

<br/>

## 4.7 식별자 네이밍 규칙과 컨벤션

식별자(identifier)는 다음과 같은 네이밍 규칙을 준수해야 한다.

**네이밍 규칙(naming rule)**

- 식별자는 특수문자를 제외한 문자, 숫자, 언더스코어(\_), 달러 기호($)를 포함할 수 있다.
- 단, 식별자는 특수문자를 제외한 문자, 언더스코어(\_), 달러 기호($)로 시작해야한다. 숫자로 시작하는 것은 허용하지 않는다.
- [예약어(reserved word)](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Lexical_grammar#reserved_words)는 식별자로 사용할 수 없다.

자바스크립트는 대소문자를 구별하므로 `firstname`과 `firstName`을 다른 변수로 취급한다.  
ES5부터 식별자에 유니코드 문자를 허용하여 알파벳 외의 한글이나 일본어도 사용할 수 있으나 권장하지 않는다.  
변수의 이름은 존재 목적을 이해할 수 있도록 작성해야한다.

<br/>

**네이밍 컨벤션(naming convention)**  
네이밍 컨벤션은 하나 이상의 영어 단어로 구성된 식별자를 만들 때 가독성을 높이기 위한 명명 규칙이다.

일반적으로 변수나 함수명은 `카멜케이스`를, 생성자 함수, 클래스의 이름에는 `파스칼 케이스`를 사용한다.

```js
// 카멜 케이스(camelCase)
var firstName;

// 스네이크 케이스(snake_case)
var first_name;

// 파스칼 케이스(PascalCase)
var FirstName;

// 헝가리언 케이스(typeHungarianCase)
var strFirstName; // type + identifier
```

<br/>

---

## Reference

📕모던 자바스크립트 Deep Dive - Chapter 04 Variable
